IF EXISTS (  SELECT * 
              FROM sys.objects 
             WHERE object_id = OBJECT_ID(N'[dbo].[sp_valida_ean13]') 
               AND type IN (N'FN')  )
DROP FUNCTION sp_valida_ean13;

GO
CREATE FUNCTION sp_valida_ean13(@number varchar(max)) RETURNS smallint AS
BEGIN
 DECLARE @c bigint
 DECLARE @r smallint
 DECLARE @i smallint
 DECLARE @x smallint
 DECLARE @sum smallint
 DECLARE @mult smallint
 DECLARE @number_split varchar(1)
 SET @x   = 0
 SET @sum = 0 
 SET @i   = 1 
 SET @c   = len(@number)
 
 -- se cb for maior que 13 
 IF @c > 13 BEGIN
    SET @r = 0
 END
 
 -- se cb for menor que 13
 IF @c < 13 BEGIN
    SET @r = 0
 END
 
 --se for nulo 
 IF @number IS NULL 
 BEGIN
    SET @r = NULL 
 END 
 ELSE 
	BEGIN

		--se não for nulo pode ser válido 
		SET @x = (SELECT CASE WHEN patindex('%[^0-9]%', @number) > 0 THEN 0 ELSE 1 END) 
  
	    IF @c = 13 AND @x = 1  
			BEGIN
				WHILE @i<=(@c-1) 
				BEGIN
 				  --fazendo um split do cb 
				  SET @number_split=substring (@number,@i,1)
				  --multiplicam-se os digitos do cb por 1 e por 3, em sequencia repetitiva de 1 e 3;
				  IF (@i % 2) = 0 BEGIN
					 SET @sum = @sum + cast(@number_split as int) * 3  
				  END ELSE BEGIN
					 SET @sum = @sum + cast(@number_split as int) * 1  
				  END
				  --incremento
				  SET @i=@i+1
				END
 
		   --com a soma do resultado das multiplicacoes...
		   --sera necessario encontrar o multiplo de 10 mais proximo do resultado da soma. 
		   --atencao: o multiplo de 10 deve ser maior ou igual ao resultado da soma (nunca menor).  
		   SET @mult = ( ( 1 + cast(@sum / 10 as int) ) * 10 ) 
		   --subtraindo o resultado da soma do multiplo que foi encontrado
		   SET @mult = @mult - @sum
		   --o resultado desta subtracao será o digito verificador
		   --entao se o ultimo digito do cb, isto e, 
		   --13o numero for igual ao resultado desta subtracao entao e um cb valido
 
		   IF cast(substring(@number,13,1) as int) = @mult BEGIN
			  SET @r = 1
		   END ELSE BEGIN
			  SET @r = 0
		   END  
 
		END 
	ELSE 
		BEGIN
		   SET @r = 0 
		END   
  
 END --fim_se
  
 RETURN (@r) 
END;
GO 
 
-- Exemplo de Uso: 
 
-- Exemplo: 01, uso simples
-- O EAN13 impresso na Lata de Leite Ninho 400g
-- SELECT dbo.sp_valida_ean13('7891000142202');   --retorna 1, pois é valido 
 
-- Exemplo: 02, descobrir todos os produtos com EAN13 ou GTIN inválido 
-- SELECT * FROM produto WHERE dbo.sp_valida_ean13(gtim)=0; 
-- GO